<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Traits\EventCategoryTraits;


class EventCategoryController extends Controller
{
    use EventCategoryTraits;

    public function getEventCategoryList(Request $request)
    {
        $EventCategory = $this->selectAllEventCategory();

        return response()->json(['status' => 'success', 'message' => 'Event category found successfully', 'data' => $EventCategory]);
    }


    public function getEventCategoryDetails($appName,$category_id)
    {
        $get_details = $this->getEventCategoryDetail($category_id);

        if($get_details){
            return response()->json(["status" => "success", "message" => "", "data" => $get_details]);
        }else{
            return response()->json(["status" => "error", "message" => config('globalMessages.edit_event_category_detail_error')]);
        }
    }

    public function deleteEventCategory(Request $request)
    {
        $getEventCat = $this->eventCategoryDelete($request);
        if($getEventCat){
            return response()->json(['status' => 'success', 'message' => config('globalMessages.delete_event_category_success_message')]);
        }else{
            return response()->json(['status' => 'error', 'message' => config('globalMessages.delete_event_category_error_message')]);
        }
    }


}
