<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use DB;
use App\Http\Traits\MapCategoryTraits;


class MapCategoryController extends Controller
{
    use MapCategoryTraits;

    public function getMapCategoryList(Request $request)
    {
        $MapCategory = $this->SelectAllMapCatory();

        return response()->json(['status' => 'success', 'message' => 'category found successfully', 'data' => $MapCategory]);
    }

    public function getMapCategoryDetails($app_name,$category_id)
    {
        $getMapCategoryDetails = $this->getMapCategoryDetail($category_id);

        if($getMapCategoryDetails){
            return response()->json(["status" => "success", "message" => "", "data" => $getMapCategoryDetails]);
        }else{
            return response()->json(["status" => "error", "message" => config('globalMessages.edit_map_category_detail_error')]);
        }

    }

    public function deleteMapCategory(Request $request)
    {
        $getMapCat = $this->categoryDelete($request);
        if($getMapCat){
           return response()->json(['status' => 'success', 'message' => config('globalMessages.delete_map_category_success_message')]);
        }else{
            return response()->json(['status' => 'error', 'message' => config('globalMessages.delete_map_category_error_message')]);
        }
    }
}
