<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\MapDirectory;
use App\Models\Category;
use DB;
use App\Http\Traits\MapDirectoryTraits;


class MapDirectoryController extends Controller
{
    use MapDirectoryTraits;

    public function getMapDirectoryList(Request $request)
    {
            $res = array();
            $category_id = $request->get('category_id');
            $mapDirectory = $this->selectAllMapDirectory($category_id);

            if (!$mapDirectory->IsEmpty()) {
                $res['status'] = 'success';
                $res['message'] = 'Explore '.ucfirst(appName($request)).' found successfully';
                $res['data'] = $mapDirectory;
            } else {
                $res['status'] = 'error';
                $res['message'] = 'No result found for this category';
            }
            return $res;
    }

    public function getMapDirectoryDetails($app_name,$map_directory_id)
    {
        $getMapDirectoryDetails = $this->getMapDirectoryDetail($map_directory_id);

        if($getMapDirectoryDetails){
            return response()->json(["status" => "success", "message" => "", "data" => $getMapDirectoryDetails]);
        }else{
            return response()->json(["status" => "error", "message" => config('globalMessages.edit_map_directory_detail_error')]);
        }

    }

    public function deleteMapDirectory(Request $request)
    {
        $getMapDirectory = $this->mapDirectoryDelete($request);
        if($getMapDirectory){
            return response()->json(['status' => 'success', 'message' => config('globalMessages.delete_map_directory_success_message')]);
        }else{
            return response()->json(['status' => 'error', 'message' => config('globalMessages.delete_map_directory_error_message')]);
        }
    }


}
