<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use DB;
use App\Http\Traits\MapCategoryTraits;


class MapCategoryController extends Controller
{

    use MapCategoryTraits;

    public function getMapCategoryList(Request $request)
    {
        $MapCategory =  $this->getAllMapCategory();

        $getDynamicFields = getIndexFields(Request(),'map_category');

        return view('map-category.index')->with(['MapCategory' => $MapCategory,'fields_name'=>$getDynamicFields]);
    }

    public function addMapCategory(Request $request)
    {
        $request->validate([
            'image' => "required|image|mimes:jpeg,png,jpg,gif,svg",
            'name' => "required",
        ]);

        extract($request->all());

        if ($request->hasFile('image')) {

            $image_path = storeImage($request,$request->image,'category');
        } else {
            $image_path = '';
        }

        $request->merge(["image_path"=>$image_path]);

        $addMapCategory = $this->craeteCategory($request);
        if($addMapCategory){
            return back()->with(["success" => config('globalMessages.map_category_create_success') ]);
        }else{
            return back()->with(["error" => config('globalMessages.map_category_create_error')]);
        }
    }



    public function editMapCategory(Request $request)
    {
        $request->validate([
            'name' => "required",
        ]);

        extract($request->all());

        $checkMapCat = $this->updateCategory($request);
        if($checkMapCat){
            return back()->with(["success" => config('globalMessages.map_category_update_success')]);
        }else{
            return back()->with(["error" => config('globalMessages.map_category_update_error') ]);
        }
    }

}
