<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Notification;
use App\Models\NotificationLog;
use App\Models\User;
use DB;


class NotificationController extends Controller
{
    public function getNotificationList()
    {
        $getDynamicFields = ["header_title" => "Send push notification", "table_header_title" => "Send push notification"];

        return view('notification.index')->with(['fields_name' => $getDynamicFields]);
    }

    public function viewNotification()
    {
        return view('notification.send-notification');
    }

    public function  sendNotification(Request $request): \Illuminate\Http\RedirectResponse
    {
        $firebaseServerKey = getFirebaseServerKey($request);

        if($firebaseServerKey == ""){
            return back()->with(['error' => config('globalMessages.send_notification_failed')]);
        }else{
            $title = $request->get('title');
            $message = $request->get('description');
            $user_type = isset( $request->user_type) ? $request->user_type : "";

            $firebaseToken = User::where('admin','!=',1)
                            ->where(function($query) use($user_type){
                                if($user_type != ""){
                                    $query->where('user_type',$user_type);
                                }
                            })
                            ->whereNotNull('device_token')
                            ->get();

            if(!$firebaseToken->IsEmpty()){
                $notification = new Notification();
                $notification->title = $title;
                $notification->description = $message;
                if($notification->save()){
                    $notification_id = $notification->id;

                    foreach($firebaseToken as $token){
                        $sendNotification = $this->sendPushNotification($firebaseServerKey,$token->device_token,$title,$message);
                        $sendNotification = json_decode($sendNotification);

                        $notification_log = new NotificationLog();
                        $notification_log->notification_id = $notification_id;
                        if(isset($sendNotification->success) && $sendNotification->success){
                            $notification_log->status = 1;
                        }else{
                            $notification_log->status = 0;
                        }
                        $notification_log->device_type = $token->device_type;
                        $notification_log->save();
                    }

                    return back()->with(['success' => "Notification send successfully."]);
                }else{
                    return back()->with(['error' => config('globalMessages.send_notification_failed')]);
                }

            }else{
                return back()->with(['error' => config('globalMessages.send_notification_failed')]);
            }

        }
    }

    public function sendPushNotification($firebase_key,$device_token,$title,$message)
    {

        $data = array(
            'body'  =>  $message,
            'title' =>  $title,
            'sound'=> "default",
        );
        $url = "https://fcm.googleapis.com/fcm/send";

        $fields = array();
        $fields['priority'] = "high";

        $fields['notification'] = $data;

        if(is_array($device_token)){
            $fields['registration_ids'] = $device_token;
        }
        else{
            $fields['to'] = $device_token;
        }

        $headers = array('Content-Type:application/json','Authorization:key='.$firebase_key);
        $curlRequest = curl_init();
        curl_setopt($curlRequest, CURLOPT_URL, $url);
        curl_setopt($curlRequest, CURLOPT_POST, true);
        curl_setopt($curlRequest, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curlRequest, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curlRequest, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($curlRequest, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curlRequest, CURLOPT_POSTFIELDS, json_encode($fields));
        $result = curl_exec($curlRequest);
        if ($result === FALSE) {
            $result = array('FCM Send Error: ' . curl_error($curlRequest));
        }
        curl_close($curlRequest);

        return $result;

    }

    public function  apisendNotification(Request $request)
    {
        $res = array() ;
        $firebaseServerKey = getFirebaseServerKey($request);

        if($firebaseServerKey == ""){
            $res['status']='error';
            $res['message']= 'error';
        }else{
            $title = $request->get('title');
            $message = $request->get('description');
            $email = $request->get('email');
           
            $firebaseToken = User::where('admin','!=',1)
                            ->where('email',$email)
                            ->first();

            if($firebaseToken){
                $sendNotification = $this->sendPushNotification($firebaseServerKey,$firebaseToken->device_token,$title,$message);
                $res['status'] = 'success';
                $res['message']="Notification send successfully."; 
                $res['data']= $sendNotification;
            }else{
                $res['status'] = 'error';
                $res['message']="error.";       
            }
        }
        return $res;
    }




}
