<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Resource;
use App\Models\ResourceCategory;
use DB;
use App\Http\Traits\ResourceTraits;


class ResourceController extends Controller
{
    use ResourceTraits ;

    public function getResourceList(Request $request,$app_name)
    {

        $resource = $this->getAllResource();
        foreach ($resource as $new_resource) {
            $categoryName = ResourceCategory::where('id', $new_resource->category_id)->first();
            if ($categoryName) {
                $new_resource->category_name = $categoryName->name;
            } else {
                $new_resource->category_name = "None";
            }
        }
        $category = ResourceCategory::orderBy('order_num', 'DESC')->get();

        $getDynamicFields = getIndexFields(Request(),'resource');

        return view('resource.index')->with(['resource'=>$resource,'category'=>$category,'fields_name'=>$getDynamicFields]);

    }

    public function addResource(Request $request): \Illuminate\Http\RedirectResponse
    {
        $request->validate([
            'image' => "required|image|mimes:jpeg,png,jpg,gif,svg",
            'title' => "required",
        ]);

        extract($request->all());

        if ($request->hasFile('image')) {

            $image_path = storeImage($request,$request->image,'resource');
        } else {
            $image_path = '';
        }

        $request->merge(["image_path"=> $image_path]);

        $addResource = $this->createResource($request);
        if($addResource){
            return back()->with(["success" => config('globalMessages.resource_create_success') ]);
        }else{
            return back()->with(["error" => config('globalMessages.resource_create_error')]);
        }

    }

    public function editResource(Request $request): \Illuminate\Http\RedirectResponse
    {
        $request->validate([
            'title' => "required",
        ]);

        extract($request->all());

        $checkResource = $this->updateResource($request);
        if($checkResource){
            return back()->with(["success" => config('globalMessages.resource_update_success')]);
        }else{
            return back()->with(["error" => config('globalMessages.resource_update_error') ]);
        }
    }






}
