<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BusinessCategory extends Model
{
    use SoftDeletes, HasFactory;

    protected $table = 'business_categories';

    protected $fillable = [
        'id',
        'image_path',
        'name',
        'category_status',
        'order_num',
        'deleted_at',
        'created_at',
        'updated_at'
    ];

    protected $casts = [
        'id' => 'integer',
        'image_path' => 'string',
        'name' => 'string',
        'order_num' => 'integer',
        'deleted_at' => 'timestamp',
        'created_at' => 'timestamp',
        'updated_at' => 'timestamp',
    ];
}
