@extends('layouts.app')
@section('title', $fields_name['header_title'])
@section('content')

<div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <button type="button" class="btn btn-primary float-right open-add-modal" data-toggle="modal" data-target="#AddModal"> ADD </button>
            <h4 class="card-title"> {{$fields_name['table_header_title']}} </h4>
            @if ($message = Session::get('success'))
            <div class="alert alert-success alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>{{ $message }}</strong>
            </div>
            @endif

            @if ($message = session()->get('error'))
            <div class="alert alert-danger alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>{{ $message }}</strong>
            </div>
            @endif
            @if (count($errors) > 0)
            <div class="alert alert-danger">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>Error!</strong> There were some problems with your input.
              <ul>
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
              </ul>
            </div>
            @endif
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table" id="directory-table">
                <thead class="text-primary">
                  <th>#</th>
                  <th>Images</th>
                  <th>Title</th>
                  <th>Category</th>
                  <th>Address</th>
                  <th>Directory Status</th>
                  <th>Order</th>
                  <th class="text-center">Action</th>
                </thead>
                <tbody>
                  @foreach($directory as $row)
                  <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>
                        @if ($row->image_path != null && file_exists($row->image_path))
                            <img src="{{url($row->image_path)}}" height="75" />
                        @else
                            <span>-</span>
                        @endif
                    </td>
                    <td>{{ $row->title }}</td>
                    <td>{{ $row->category_name }}</td>
                    <td>{{ $row->address }}</td>
                    <td>{{ ucfirst($row->directory_status) }}</td>
                    <td>{{ $row->order_num }}</td>
                    <td class="text-center">
                      <div class="dropdown">
                        <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                          Action
                        </button>
                        <div class="dropdown-menu">
                            <a class="dropdown-item open-edit-modal"  data-id="{{ $row->id }}" href="javascript:void(0)">Edit</a>
                            <a class="dropdown-item open-edit-delete" data-id="{{ $row->id }}" href="javascript:void(0)">Delete</a>
                      </div>
                      </div>
                    </td>
                  </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
</div>

<!-- Add modal -->
@include('directory.modal.add-directory-modal')
<!-- edit Modal -->
@include('directory.modal.edit-directory-modal')

@endsection

@section('script-section')
    <script>
        $(document).ready(function() {
            $('#directory-table').DataTable();

            $('.open-add-modal').on('click',function(){
                $('#AddModal').find('form').trigger('reset');
            let $alerts = $('#AddModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
            }) ;
        });

        $('#addform').validate({
            rules: {
                image: {
                    required: true,
                },
                title: {
                    required: true,
                },
            },
            messages: {
                image: {
                    required: "{{ config('globalMessages.required_message.image') }}",
                },
                title: {
                    required: "{{ config('globalMessages.required_message.title') }}"
                },
            },
        });

        $('.open-edit-modal').on('click',function(){
            let directory_id = $(this).data('id');
            $.ajax({
                method: "GET",
                url: "{{ url( 'api/'.appName(Request())  . '/get-directory-details')  }}/" + directory_id,
                success:function(data){
                    if (data.status != 'success') {
                        Swal.fire({
                            icon:'error',
                            title:"Error!",
                            text: data.message
                        })
                        return;
                    }
                    let print_data = data.data;

                    $('.title1').val(print_data.title);
                    $('.category_id1').val(print_data.category_id);
                    $('.description1').val(print_data.description);
                    $('.latitude1').val(print_data.latitude);
                    $('.longitude1').val(print_data.longitude);
                    $('.phone1').val(print_data.phone);
                    $('.url1').val(print_data.url);
                    $('.video_url1').val(print_data.video_url);
                    $('.facebook_url1').val(print_data.facebook_url);
                    $('.instagram_url1').val(print_data.instagram_url);
                    $('.twitter_url1').val(print_data.twitter_url);
                    $('.address1').val(print_data.address);
                    $('.directory_status1').val(print_data.directory_status);
                    $('.order_num1').val(print_data.order_num);
                    $('#directory_id').val(print_data.id);
                    $('#editModal').modal('show');
                },
                error:function(err){
                    console.log(err)
                }
            });

        });

        $('#editform').validate({
            rules: {
                title: {
                    required: true,
                },
            },
            messages: {
                title: {
                    required: "{{ config('globalMessages.required_message.title') }}"
                },
            },
        });

        $('#editModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#editModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        $('#AddModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#AddModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        $('.open-edit-delete').on('click',function(){
           Swal.fire({
               icon:"warning",
               title: "{{ config('globalMessages.delete_directory_warning_title')  }}",
               text: "{{ config('globalMessages.delete_directory_warning_text')  }}",
               showConfirmButton: true,
               showCancelButton: true,
               confirmButtonText: "Yes",
               cancelButtonText: "No"
           }).then((ok) => {
                if(ok['isConfirmed']){
                    let directory_id = $(this).data('id');

                    $.ajax({
                        type:"post",
                        url: "{{ url('api/'.appName(Request()) . '/delete-directory')  }}",
                        data:{
                            "_token": "{{ csrf_token() }}",
                            "directory_id": directory_id
                        },
                        success:function(data){
                            if(data.status == "success"){
                                Swal.fire({
                                   icon:"success",
                                   title:"Success",
                                   text: data.message
                                }).then((ok) => {
                                    if(ok){
                                        window.location.reload();
                                    }
                                });

                            }else{
                                Swal.fire({
                                    icon:"error",
                                    title:"Error",
                                    text: data.message
                                });
                            }
                        },
                        error:function(error){
                            console.log(error);
                        }
                    })
                }
           });
        });


    </script>
@endsection
