@extends('layouts.app')
@section('title',  $fields_name['header_title'])
@section('content')

<div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <button type="button" class="btn btn-primary float-right open-add-modal" data-toggle="modal" data-target="#AddModal"> ADD </button>
            <h4 class="card-title"> {{ $fields_name['table_header_title']}}</h4>
            @if ($message = Session::get('success'))
            <div class="alert alert-success alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>{{ $message }}</strong>
            </div>
            @endif

            @if ($message = session()->get('error'))
            <div class="alert alert-danger alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>{{ $message }}</strong>
            </div>
            @endif
            @if (count($errors) > 0)
            <div class="alert alert-danger">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>Error!</strong> There were some problems with your input.
              <ul>
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
              </ul>
            </div>
            @endif
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table" id="mapcategory-table">
                <thead class="text-primary">
                  <th>#</th>
                  <th>Images</th>
                  <th>Name</th>
                  <th>Order</th>
                  <th>Category Status</th>
                  <th class="text-center">Action</th>
                </thead>
                <tbody>
                  @foreach($MapCategory as $row)
                  <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>
                        @if ($row->image_path != null && file_exists($row->image_path))
                            <img src="{{url($row->image_path)}}" height="75" />
                        @else
                            <span>-</span>
                        @endif
                    </td>
                    <td>{{ $row->name }}</td>
                    <td>{{ $row->order_num }}</td>
                    <td>{{ ucfirst($row->category_status) }}</td>

                    <td class="text-center">
                      <div class="dropdown">
                        <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                          Action
                        </button>
                        <div class="dropdown-menu">
                            <a class="dropdown-item open-edit-modal"  data-id="{{ $row->id }}" href="javascript:void(0)">Edit</a>
                            <a class="dropdown-item open-edit-delete" data-id="{{ $row->id }}" href="javascript:void(0)">Delete</a>
                      </div>
                      </div>
                    </td>
                  </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
</div>

<!-- Add modal -->
@include('map-category.modal.add-mapcategory-modal')
<!-- edit Modal -->
@include('map-category.modal.edit-mapcategory-modal')

@endsection

@section('script-section')

    <script>
        $(document).ready(function() {
            $('#mapcategory-table').DataTable();

            $('.open-add-modal').on('click',function(){
                $('#AddModal').find('form').trigger('reset');
            let $alerts = $('#AddModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
            }) ;
        });
        $('#addform').validate({
            rules: {
                image: {
                    required: true,
                },
                name: {
                    required: true,
                },
            },
            messages: {
                image: {
                    required: "{{ config('globalMessages.required_message.image') }}",
                },
                name: {
                    required: "{{ config('globalMessages.required_message.name') }}"
                },
            },

        });

        $('.open-edit-modal').on('click',function(){
            let category_id = $(this).data('id');
            $.ajax({
                method: "GET",
                url: "{{ url( 'api/'.appName(Request())  . '/get-category-details')  }}/" + category_id,
                success:function(data){
                    if (data.status != 'success') {
                        Swal.fire({
                            icon:'error',
                            title:"Error!",
                            text: data.message
                        })
                        return;
                    }
                    let print_data = data.data;

                    $('.name1').val(print_data.name);
                    $('.category_status1').val(print_data.category_status);
                    $('.order_num1').val(print_data.order_num);
                    $('#category_id').val(print_data.id);
                    $('#editModal').modal('show');
                },
                error:function(err){
                    console.log(err)
                }
            });

        });

        $('#editform').validate({
            rules: {
                name: {
                    required: true,
                },
            },
            messages: {
                name: {
                    required: "{{ config('globalMessages.required_message.name') }}"
                },
            },
        });

        // reset edit form and validation errors and message
        $('#editModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#editModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        // reset add form and validation errors and message
        $('#AddModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#AddModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        $('.open-edit-delete').on('click',function(){
           Swal.fire({
               icon:"warning",
               title: "{{ config('globalMessages.delete_map_category_warning_title')  }}",
               text: "{{ config('globalMessages.delete_map_category_warning_text')  }}",
               showConfirmButton: true,
               showCancelButton: true,
               confirmButtonText: "Yes",
               cancelButtonText: "No"
           }).then((ok) => {
                if(ok['isConfirmed']){
                    let category_id = $(this).data('id');

                    $.ajax({
                        type:"post",
                        url: "{{ url('api/'.appName(Request()) . '/delete-category')  }}",
                        data:{
                            "_token": "{{ csrf_token() }}",
                            "category_id": category_id
                        },
                        success:function(data){
                            if(data.status == "success"){
                                Swal.fire({
                                   icon:"success",
                                   title:"Success",
                                   text: data.message
                                }).then((ok) => {
                                    if(ok){
                                        window.location.reload();
                                    }
                                });

                            }else{
                                Swal.fire({
                                    icon:"error",
                                    title:"Error",
                                    text: data.message
                                });
                            }
                        },
                        error:function(error){
                            console.log(error);
                        }
                    })
                }
           });
        });


    </script>


@endsection
