@extends('layouts.app')
@section('title', 'Resource Category')
@section('content')

<div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <button type="button" class="btn btn-primary float-right" data-toggle="modal" data-target="#AddModal"> ADD </button>
            <h4 class="card-title"> Resource category</h4>
            @if ($message = Session::get('success'))
            <div class="alert alert-success alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>{{ $message }}</strong>
            </div>
            @endif

            @if ($message = session()->get('error'))
            <div class="alert alert-danger alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>{{ $message }}</strong>
            </div>
            @endif
            @if (count($errors) > 0)
            <div class="alert alert-danger">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>Error!</strong> There were some problems with your input.
              <ul>
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
              </ul>
            </div>
            @endif
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table" id="rescategory-table">
                <thead class="text-primary">
                  <th>#</th>
                  <th>Images</th>
                  <th>Name</th>
                  <th>Order</th>
                  <th>Category Status</th>
                  <th class="text-center">Action</th>
                </thead>
                <tbody>
                  @foreach($ResourceCategory as $row)
                  <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>
                        @if ($row->image_path != null && file_exists($row->image_path))
                            <img src="{{url($row->image_path)}}" height="75" />
                        @else
                            <span>-</span>
                        @endif
                    </td>
                    <td>{{ $row->name }}</td>
                    <td>{{ $row->order_num }}</td>
                    <td>{{ ucfirst($row->category_status) }}</td>

                    <td class="text-center">
                      <div class="dropdown">
                        <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                          Action
                        </button>
                        <div class="dropdown-menu">
                            <a class="dropdown-item open-edit-modal"  data-id="{{ $row->id }}" href="javascript:void(0)">Edit</a>
                            <a class="dropdown-item open-edit-delete" data-id="{{ $row->id }}" href="javascript:void(0)">Delete</a>
                      </div>
                      </div>
                    </td>
                  </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
</div>

<!-- Add modal -->
@include('resource-category.modal.add-resource-category-modal')
<!-- edit Modal -->
@include('resource-category.modal.edit-resource-category-modal')

@endsection

@section('script-section')

    <script>
        $(document).ready(function() {
            $('#rescategory-table').DataTable();
        });
        $('#addform').validate({
            rules: {
                image: {
                    required: true,
                },
                name: {
                    required: true,
                },
            },
            messages: {
                image: {
                    required: "{{ config('globalMessages.required_message.image') }}",
                },
                name: {
                    required: "{{ config('globalMessages.required_message.name') }}"
                },
            },

        });

        $('.open-edit-modal').on('click',function(){
            let res_cat_id = $(this).data('id');
            $.ajax({
                method: "GET",
                url: "{{ url(  'api/'.appName(Request())  . '/get-resource-category-details')  }}/" + res_cat_id,
                success:function(data){
                    if (data.status != 'success') {
                        Swal.fire({
                            icon:'error',
                            title:"Error!",
                            text: data.message
                        })
                        return;
                    }
                    let print_data = data.data;

                    $('.name1').val(print_data.name);
                    $('.category_status1').val(print_data.category_status);
                    $('.order_num1').val(print_data.order_num);
                    $('#res_cat_id').val(print_data.id);
                    $('#editModal').modal('show');
                },
                error:function(err){
                    console.log(err)
                }
            });

        });

        $('#editform').validate({
            rules: {
                name: {
                    required: true,
                },
            },
            messages: {
                name: {
                    required: "{{ config('globalMessages.required_message.name') }}"
                },
            },
        });

        // reset edit form and validation errors and message
        $('#editModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#editModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        // reset add form and validation errors and message
        $('#AddModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#AddModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        $('.open-edit-delete').on('click',function(){
           Swal.fire({
               icon:"warning",
               title: "{{ config('globalMessages.delete_resource_category_warning_title')  }}",
               text: "{{ config('globalMessages.delete_resource_category_warning_text')  }}",
               showConfirmButton: true,
               showCancelButton: true,
               confirmButtonText: "Yes",
               cancelButtonText: "No"
           }).then((ok) => {
                if(ok['isConfirmed']){
                    let res_cat_id = $(this).data('id');

                    $.ajax({
                        type:"post",
                        url: "{{ url('api/'.appName(Request()) .'/delete-resource-category')  }}",
                        data:{
                            "_token": "{{ csrf_token() }}",
                            "res_cat_id": res_cat_id
                        },
                        success:function(data){
                            if(data.status == "success"){
                                Swal.fire({
                                   icon:"success",
                                   title:"Success",
                                   text: data.message
                                }).then((ok) => {
                                    if(ok){
                                        window.location.reload();
                                    }
                                });

                            }else{
                                Swal.fire({
                                    icon:"error",
                                    title:"Error",
                                    text: data.message
                                });
                            }
                        },
                        error:function(error){
                            console.log(error);
                        }
                    })
                }
           });
        });


    </script>


@endsection
