<!DOCTYPE html>
<html lang="en">

<head>
    <title>Login</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!--===============================================================================================-->
    <link rel="icon" href="<?php echo e(asset('assets')); ?>/logo/logo-<?php echo e(appName(Request())); ?>.png">
    <!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/login/vendor/bootstrap/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/login/fonts/font-awesome-4.7.0/css/font-awesome.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/login/vendor/animate/animate.css')); ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/login/css/util.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/login/css/main.css')); ?>">

</head>
<style>
    .login100-form-avatar img {
    width: 90%;
}
</style>
<body>

    <div class="limiter">

        <div class="container-login100">
            <div class="wrap-login100 p-t-85 p-b-20">
                    <?php if(session()->get('error')): ?>
                    <div class="col-md-3"></div>
                    <div class="col-md-12">
                        <div class="alert alert-danger">
                            <strong>Error!</strong> <?php echo e(session()->get('error')); ?>

                        </div>
                    </div>

                    <?php endif; ?>
                <form class="login100-form validate-form" method="POST" action="<?php echo e(url('app/' . appName(Request()) . '/post-login' )); ?>">
                    <?php echo csrf_field(); ?>
                    <span class="login100-form-avatar">
                        
                        <img src="<?php echo e(asset('assets').'/logo/logo-'.appName(Request()). '.png'); ?> " alt="AVATAR">
                    </span>
                    <span class="login100-form-title m-t-50">
                        Welcome
                    </span>
                    <div class="wrap-input100 -input m-t-50 m-b-35" data-validate="Enter Email">
                        <input id="text" class="input100" type="text" name="email">
                        <span class="focus-input100" data-placeholder="Email"></span>
                    </div>

                    <div class="wrap-input100 validate-input m-b-50" data-validate="Enter password">
                        <input id="password" class="input100" type="password" name="password">
                        <span class="focus-input100" data-placeholder="Password"></span>
                    </div>

                    <div class="container-login100-form-btn">
                        <button type="submit" class="login100-form-btn">
                            Login
                        </button>
                    </div>

                    <ul class="login-more p-t-100">
                        <li class="m-b-8">
                            <span class="txt1">
                                Forgot
                            </span>

                            <a href="#" class="txt2">
                                Username / Password?
                            </a>
                        </li>


                    </ul>
                </form>
            </div>
        </div>
    </div>


    <div id="dropDownSelect1"></div>

    <!--===============================================================================================-->
    <script src="<?php echo e(asset('assets/login/vendor/jquery/jquery-3.2.1.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/login/js/main.js')); ?>"></script>

</body>

</html>
<?php /**PATH C:\xampp\htdocs\chamber-ddd\resources\views/auth/login.blade.php ENDPATH**/ ?>