<?php $__env->startSection('title', 'Explore Chehalem'); ?>
<?php $__env->startSection('content'); ?>

<div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <button type="button" class="btn btn-primary float-right" data-toggle="modal" data-target="#AddModal"> ADD </button>
            <h4 class="card-title">Explore Chehalem</h4>
            <?php if($message = Session::get('success')): ?>
            <div class="alert alert-success alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong><?php echo e($message); ?></strong>
            </div>
            <?php endif; ?>

            <?php if(count($errors) > 0): ?>
            <div class="alert alert-danger">
              <strong>Whoops!</strong> There were some problems with your input.
              <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
            <?php endif; ?>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table" id="mapdirectory-table">
                <thead class="text-primary">
                  <th>#</th>
                  <th>Images</th>
                  <th>Title</th>
                  <th>Category Name</th>
                  <th>Address</th>
                  <th>Explore Status</th>
                  <th>Order</th>
                  <th class="text-center">Action</th>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $MapDirectory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><img src="<?php echo e(url($row->image_path)); ?>" height="75" /></td>
                    <td><?php echo e($row->title); ?></td>
                    <td><?php echo e($row->category_name); ?></td>
                    <td><?php echo e($row->address); ?></td>
                    <td><?php echo e(ucfirst($row->explore_status)); ?></td>
                    <td><?php echo e($row->order_num); ?></td>
                    <td class="text-center">
                      <div class="dropdown">
                        <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                          Action
                        </button>
                        <div class="dropdown-menu">
                            <a class="dropdown-item open-edit-modal"  data-id="<?php echo e($row->id); ?>" href="javascript:void(0)">Edit</a>
                            <a class="dropdown-item open-edit-delete" data-id="<?php echo e($row->id); ?>" href="javascript:void(0)">Delete</a>
                      </div>
                      </div>
                    </td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
</div>

<!-- Add modal -->
<?php echo $__env->make('map-directory.modal.add-map-directory-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- edit Modal -->
<?php echo $__env->make('map-directory.modal.edit-map-directory-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script-section'); ?>

    <script>
        $(document).ready(function() {
            $('#mapdirectory-table').DataTable();
        });

        $('#addform').validate({
            rules: {
                image: {
                    required: true,
                },
                title: {
                    required: true,
                },
            },
            messages: {
                image: {
                    required: "<?php echo e(config('globalMessages.required_message.image')); ?>",
                },
                title: {
                    required: "<?php echo e(config('globalMessages.required_message.title')); ?>"
                },
            },
        });

        $('.open-edit-modal').on('click',function(){
            let map_directory_id = $(this).data('id');
            $.ajax({
                method: "GET",
                url: "<?php echo e(url(baseRedirectUrl(Request()) . '/get-map-directory-details')); ?>/" + map_directory_id,
                success:function(data){
                    if (data.status != 'success') {
                        Swal.fire({
                            icon:'error',
                            title:"Error!",
                            text: data.message
                        })
                        return;
                    }
                    let print_data = data.data;

                    $('#e_title').val(print_data.title);
                    $('#e_category_id').val(print_data.category_id);
                    $('#e_description').val(print_data.description);
                    $('#e_latitude').val(print_data.latitude);
                    $('#e_longitude').val(print_data.longitude);
                    $('#e_phone').val(print_data.phone);
                    $('#e_url').val(print_data.url);
                    $('#e_video_url').val(print_data.video_url);
                    $('#e_facebook_url').val(print_data.facebook_url);
                    $('#e_instagram_url').val(print_data.instagram_url);
                    $('#e_twitter_url').val(print_data.twitter_url);
                    $('#e_video_url').val(print_data.video_url);
                    $('#e_address').val(print_data.address);
                    $('#e_explore_status').val(print_data.explore_status);
                    $('#e_order_num').val(print_data.order_num);
                    $('#map_directory_id').val(print_data.id);
                    $('#editModal').modal('show');
                },
                error:function(err){
                    console.log(err)
                }
            });

        });

        $('#editform').validate({
            rules: {
                title: {
                    required: true,
                },
            },
            messages: {
                title: {
                    required: "<?php echo e(config('globalMessages.required_message.title')); ?>"
                },
            },
        });

        $('#editModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#editModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        $('#AddModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#AddModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        $('.open-edit-delete').on('click',function(){
           Swal.fire({
               icon:"warning",
               title: "<?php echo e(config('globalMessages.delete_map_directory_warning_title')); ?>",
               text: "<?php echo e(config('globalMessages.delete_map_directory_warning_text')); ?>",
               showConfirmButton: true,
               showCancelButton: true,
               confirmButtonText: "Yes",
               cancelButtonText: "No"
           }).then((ok) => {
                if(ok['isConfirmed']){
                    let map_directory_id = $(this).data('id');

                    $.ajax({
                        type:"post",
                        url: "<?php echo e(url(baseRedirectUrl(Request()) . '/delete-directory')); ?>",
                        data:{
                            "_token": "<?php echo e(csrf_token()); ?>",
                            "map_directory_id": map_directory_id
                        },
                        success:function(data){
                            if(data.status == "success"){
                                Swal.fire({
                                   icon:"success",
                                   title:"Success",
                                   text: data.message
                                }).then((ok) => {
                                    if(ok){
                                        window.location.reload();
                                    }
                                });

                            }else{
                                Swal.fire({
                                    icon:"error",
                                    title:"Error",
                                    text: data.message
                                });
                            }
                        },
                        error:function(error){
                            console.log(error);
                        }
                    })
                }
           });
        });


    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\chamber-app-ddd\resources\views/map-directory/index.blade.php ENDPATH**/ ?>