@extends('layouts.app')
@section('title', 'Resource')
@section('content')

<div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <button type="button" class="btn btn-primary float-right" data-toggle="modal" data-target="#AddModal"> ADD </button>
            <h4 class="card-title"> Resource </h4>
            @if ($message = Session::get('success'))
            <div class="alert alert-success alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>{{ $message }}</strong>
            </div>
            @endif

            @if ($message = session()->get('error'))
            <div class="alert alert-danger alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>{{ $message }}</strong>
            </div>
            @endif
            @if (count($errors) > 0)
            <div class="alert alert-danger">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>Error!</strong> There were some problems with your input.
              <ul>
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
              </ul>
            </div>
            @endif
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table" id="resource-table">
                <thead class="text-primary">
                  <th>#</th>
                  <th>Images</th>
                  <th>Title</th>
                  <th>Category</th>
                  <th>Address</th>
                  <th>Resource Status</th>
                  <th>Order</th>
                  <th class="text-center">Action</th>
                </thead>
                <tbody>
                  @foreach($resource as $row)
                  <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td><img src="{{url($row->image_path)}}" height="75" /></td>
                    <td>{{ $row->title }}</td>
                    <td>{{ $row->category_name }}</td>
                    <td>{{ $row->address }}</td>
                    <td>{{ ucfirst($row->resource_status) }}</td>
                    <td>{{ $row->order_num }}</td>
                    <td class="text-center">
                      <div class="dropdown">
                        <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                          Action
                        </button>
                        <div class="dropdown-menu">
                            <a class="dropdown-item open-edit-modal"  data-id="{{ $row->id }}" href="javascript:void(0)">Edit</a>
                            <a class="dropdown-item open-edit-delete" data-id="{{ $row->id }}" href="javascript:void(0)">Delete</a>
                      </div>
                      </div>
                    </td>
                  </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
</div>

<!-- Add modal -->
@include('resource.modal.add-resource-modal')
<!-- edit Modal -->
@include('resource.modal.edit-resource-modal')

@endsection

@section('script-section')
    <script>
         $(document).ready(function() {
            $('#resource-table').DataTable();
        });


        $('#addform').validate({
            rules: {
                image: {
                    required: true,
                },
                title: {
                    required: true,
                },
            },
            messages: {
                image: {
                    required: "{{ config('globalMessages.required_message.image') }}",
                },
                title: {
                    required: "{{ config('globalMessages.required_message.title') }}"
                },
            },
        });

        $('.open-edit-modal').on('click',function(){
            let resource_id = $(this).data('id');
            $.ajax({
                method: "GET",
                url: "{{ url(baseRedirectUrl(Request()) . '/get-resource-details')  }}/" + resource_id,
                success:function(data){
                    if (data.status != 'success') {
                        Swal.fire({
                            icon:'error',
                            title:"Error!",
                            text: data.message
                        })
                        return;
                    }
                    let print_data = data.data;

                    $('#e_title').val(print_data.title);
                    $('#e_category_id').val(print_data.category_id);
                    $('#e_description').val(print_data.description);
                    $('#e_latitude').val(print_data.latitude);
                    $('#e_longitude').val(print_data.longitude);
                    $('#e_phone').val(print_data.phone);
                    $('#e_url').val(print_data.url);
                    $('#e_address').val(print_data.address);
                    $('#e_resource_status').val(print_data.resource_status);
                    $('#e_order_num').val(print_data.order_num);
                    $('#resource_id').val(print_data.id);
                    $('#editModal').modal('show');
                },
                error:function(err){
                    console.log(err)
                }
            });

        });

        $('#editform').validate({
            rules: {
                title: {
                    required: true,
                },
            },
            messages: {
                title: {
                    required: "{{ config('globalMessages.required_message.title') }}"
                },
            },
        });

        $('#editModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#editModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        $('#AddModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#AddModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        $('.open-edit-delete').on('click',function(){
           Swal.fire({
               icon:"warning",
               title: "{{ config('globalMessages.delete_resource_warning_title')  }}",
               text: "{{ config('globalMessages.delete_resource_warning_text')  }}",
               showConfirmButton: true,
               showCancelButton: true,
               confirmButtonText: "Yes",
               cancelButtonText: "No"
           }).then((ok) => {
                if(ok['isConfirmed']){
                    let resource_id = $(this).data('id');

                    $.ajax({
                        type:"post",
                        url: "{{ url(baseRedirectUrl(Request()) . '/delete-resource')  }}",
                        data:{
                            "_token": "{{ csrf_token() }}",
                            "resource_id": resource_id
                        },
                        success:function(data){
                            if(data.status == "success"){
                                Swal.fire({
                                   icon:"success",
                                   title:"Success",
                                   text: data.message
                                }).then((ok) => {
                                    if(ok){
                                        window.location.reload();
                                    }
                                });

                            }else{
                                Swal.fire({
                                    icon:"error",
                                    title:"Error",
                                    text: data.message
                                });
                            }
                        },
                        error:function(error){
                            console.log(error);
                        }
                    })
                }
           });
        });

    </script>
@endsection
