<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;


return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->tinyInteger('admin')->default(0);
            $table->string('email');
            $table->string('password');
            $table->string('firstname',40);
            $table->string('lastname',40);
            $table->string('zip_code',11)->nullable()->default(null);
            $table->tinyInteger('user_type')->nullable()->default(0);
            $table->tinyInteger('is_member')->nullable()->default(0);
            $table->text('device_token')->nullable()->default(null);
            $table->enum('device_type',['android','ios'])->nullable()->default(null);
            $table->text('password_reset_token')->nullable()->default(null);
            $table->dateTime('password_reset_time')->nullable()->default(null);
            $table->rememberToken();
            $table->softDeletes();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });

        // Insert some stuff
        DB::table('users')->insert(
            array(
                'admin' => 1,
                'email' => 'dev@pointnsave.com',
                'password' => Hash::make('pointnsave'),
                'firstname' => 'admin',
                'lastname' => 'admin',
            )
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
