<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DirectoryCategory;
use DB;
use App\Http\Traits\DirectoryCategoryTraits;


class DirectoryCategoryController extends Controller
{

    use DirectoryCategoryTraits;

    public function getDirectoryCategoryList(Request $request)
    {
        $DirectoryCategory = $this->getAllDirectoryCategory();
        $getDynamicFields = getIndexFields(Request(),'directory_category');

        return view('directory-category.index')->with(['DirectoryCategory'=>$DirectoryCategory,'fields_name'=>$getDynamicFields]);

    }

    public function addDirectoryCategory(Request $request): \Illuminate\Http\RedirectResponse
    {
        $request->validate([
            'image' => "required|image|mimes:jpeg,png,jpg,gif,svg",
            'name' => "required",
        ]);

        extract($request->all());

        if ($request->hasFile('image')) {

            $image_path = storeImage($request,$request->image,'directory_category');
        } else {
            $image_path = '';
        }

        $request->merge(['image_path' =>$image_path]);

        $addDircat = $this->createDirectoryCategory($request);

        if($addDircat){
            return back()->with(["success" => config('globalMessages.directory_category_create_success') ]);
        }else{
            return back()->with(["error" => config('globalMessages.directory_category_create_error')]);
        }

    }

    public function editDirectoryCategory(Request $request): \Illuminate\Http\RedirectResponse
    {
        $request->validate([
            'name' => "required",
        ]);

        extract($request->all());

        $getAds = $this->updateDirectoryCategory($request);
        if($getAds){
            return back()->with(["success" => config('globalMessages.directory_category_update_success') ]);
        }else{
            return back()->with(["error" => config('globalMessages.directory_category_update_error') ]);
        }
    }



}
