<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Directory;
use App\Models\DirectoryCategory;
use DB;
use App\Http\Traits\DirectoryTraits;


class DirectoryController extends Controller
{
    use DirectoryTraits;

    public function getDirectoryList(Request $request,$app_name)
    {
        $directory = $this->getAllDirectory();
        foreach ($directory as $new_directory) {
            $categoryName = DirectoryCategory::where('id', $new_directory->category_id)->first();
            if ($categoryName) {
                $new_directory->category_name = $categoryName->name;
            } else {
                $new_directory->category_name = "None";
            }
        }
        $category = DirectoryCategory::orderBy('order_num', 'DESC')->get();
        $getDynamicFields = getIndexFields(Request(),'directory');

        return view('directory.index')->with(['directory'=>$directory,'category'=>$category,'fields_name'=>$getDynamicFields]);

    }

    public function addDirectory(Request $request): \Illuminate\Http\RedirectResponse
    {
        $request->validate([
            'image' => "required|image|mimes:jpeg,png,jpg,gif,svg",
            'title' => "required",
        ]);

        extract($request->all());

        if ($request->hasFile('image')) {

            $image_path = storeImage($request,$request->image,'directory');
        } else {
            $image_path = '';
        }
        $request->merge(['image_path' =>$image_path]);

        $addDirectory = $this->createDirectory($request);
        if($addDirectory){
            return back()->with(["success" => config('globalMessages.directory_create_success') ]);
        }else{
            return back()->with(["error" => config('globalMessages.directory_create_error')]);
        }

    }

    public function editDirectory(Request $request)
    {
        $request->validate([
            'title' => "required",
        ]);

        extract($request->all());
        $checkDirectory = $this->updateDirectory($request);
        if($checkDirectory){
            return back()->with(["success" => config('globalMessages.directory_update_success')]);
        }else{
            return back()->with(["error" => config('globalMessages.directory_update_error') ]);
        }
    }


}
