<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Traits\EventCategoryTraits;

class EventCategoryController extends Controller
{
    use EventCategoryTraits;

    public function getEventCategoryList(Request $request)
    {
        $EventCategory = $this->getAllEventCategory();
        $getDynamicFields = getIndexFields(Request(),'event_category');

        return view('event-category.index')->with(['EventCategory'=>$EventCategory,'fields_name'=>$getDynamicFields]);

    }

    public function addEventCategory(Request $request)
    {
        $request->validate([
            'image' => "required|image|mimes:jpeg,png,jpg,gif,svg",
            'name' => "required",
        ]);

        extract($request->all());

        if ($request->hasFile('image')) {

            $image_path = storeImage($request,$request->image,'event_category');
        } else {
            $image_path = '';
        }

        $request->merge(['image_path' =>$image_path]);

        $addEventcat = $this->createEventCategory($request);

        if($addEventcat){
            return back()->with(["success" => config('globalMessages.event_category_create_success') ]);
        }else{
            return back()->with(["error" => config('globalMessages.event_category_create_error')]);
        }

    }

    public function editEventCategory(Request $request)
    {
        $request->validate([
            'name' => "required",
        ]);

        extract($request->all());

        $getEventCategory = $this->updateEventCategory($request);
        if($getEventCategory){
            return back()->with(["success" => config('globalMessages.event_category_update_success') ]);
        }else{
            return back()->with(["error" => config('globalMessages.event_category_update_error') ]);
        }
    }

}
