<?php

namespace App\Http\Traits;
use App\Models\Directory;
use DB;

trait DirectoryTraits
{
    public function getAllDirectory()
    {
        return Directory::all();
    }

    public function selectAllDirectory($category_id)
    {

        return DB::table('directory as d')
        ->select('d.*','dc.name as category_name', 'dc.image_path as cat_image',
        DB::raw("CONCAT('".env('APP_URL')."/',d.image_path) as image_path"),
        DB::raw("CONCAT('".env('APP_URL')."/',dc.image_path) as cat_image"))
        ->leftJoin('directory_categories as dc','dc.id','=','d.category_id')
        ->orWhere(function($query) use($category_id){
            if($category_id != ""){
                $query->where('d.category_id',$category_id);
            }
        })
        ->where('d.directory_status', '=', 'active')
        ->where('d.deleted_at', '=', Null)
        ->orderBy('d.order_num', 'asc')
        ->get();
    }

    public function getDirectoryDetail($directory_id)
    {
        return Directory::find($directory_id);

    }

    public function createDirectory($request)
    {
        return Directory::create($request->all());
    }

    public function updateDirectory($request)
    {
        $directory_id = $request->get('directory_id');

        $arr = $request->all();
        unset($arr['_token']);
        unset($arr['directory_id']);

        $currentImagePath = $this->getImagePath($directory_id);
        $image_path = "";
        if ($request->hasFile('image')) {
            $image_path = storeImage($request,$request->image,'directory');
        } else {
            $image_path = '';
        }

        if($image_path != ""){
            $arr = array_merge($arr,['image_path' => $image_path]);
        }
        unset($arr['image']);

        $directory= Directory::where('id',$directory_id)->update($arr);
            if($image_path != "" && $currentImagePath != ""){
                if(file_exists($currentImagePath)){
                    unlink($currentImagePath);
                }
            }
        return $directory;
    }

    public function getImagePath($directory_id)
    {
        $image_path = "";

        $directory = Directory::find($directory_id);
        if($directory){
            $image_path = $directory->image_path;
        }

        return $image_path;
    }

    public function directoryDelete($request)
    {
        $directory_id = $request->get('directory_id');
        return Directory::where('id',$directory_id)->delete();
    }


}
