<?php

namespace App\Http\Traits;
use App\Models\EventCategory;
use DB;

trait EventCategoryTraits{

    public function getAllEventCategory()
    {
        return EventCategory::all();
    }

    public function selectAllEventCategory()
    {
        return EventCategory::select('*',DB::raw("CONCAT('".env('APP_URL')."/',image_path) as image_path"))
        ->where('category_status','active')
        ->get();
    }

    public function getEventCategoryDetail($event_category_id)
    {
        return EventCategory::find($event_category_id);
    }


    public function createEventCategory($request)
    {
        return EventCategory::create($request->all());
    }

    public function updateEventCategory($request)
    {
        $event_category_id = $request->get('event_category_id');

        $arr = $request->all();
        unset($arr['_token']);
        unset($arr['event_category_id']);

        $currentImagePath = $this->getImagePath($event_category_id);
        $image_path = "";
        if ($request->hasFile('image')) {
            $image_path = storeImage($request,$request->image,'event_category');
        } else {
            $image_path = '';
        }

        if($image_path != ""){
            $arr = array_merge($arr,['image_path' => $image_path]);
        }
        unset($arr['image']);

        $Eventcategory= EventCategory::where('id',$event_category_id)->update($arr);
        if($image_path != "" && $currentImagePath != ""){
            if(file_exists($currentImagePath)){
                unlink($currentImagePath);
            }
        }

        return $Eventcategory;
    }

    public function getImagePath($event_category_id)
    {
        $image_path = "";

        $event_cat = EventCategory::find($event_category_id);
        if($event_cat){
            $image_path = $event_cat->image_path;
        }

        return $image_path;
    }

    public function eventCategoryDelete($request)
    {
        $event_category_id = $request->get('event_category_id');
        return EventCategory::where('id',$event_category_id)->delete();
    }



}

?>