<?php
namespace App\Http\Traits;
use App\Models\Resource;
use DB;

trait ResourceTraits {

    public function getAllResource()
    {
        return Resource::all();
    }

    public function selectAllRescource($request)
    {
        $category_id = $request->get('category_id');

        return DB::table('resource as r')
        ->select('r.*', 'c.name as category_name', DB::raw("CONCAT('".env('APP_URL')."/',r.image_path) as image_path"))
        ->leftJoin('resource_categories as c', 'c.id', '=', 'r.category_id')
        ->orWhere(function($query) use($category_id){
            if($category_id != ""){
                $query->where('r.category_id',$category_id);
            }
        })
        ->where('r.resource_status', '=', 'active')
        ->where('r.deleted_at', '=', null)
        ->orderBy('r.order_num', 'asc')
        ->get();
    }


    public function getResourceDetail($resource_id)
    {
        return Resource::find($resource_id);
    }

    public function createResource($request)
    {
        return Resource::create($request->all());
    }

    public function updateResource($request)
    {
        $resource_id = $request->get('resource_id');

        $arr = $request->all();
        unset($arr['_token']);
        unset($arr['resource_id']);

        $currentImagePath = $this->getImagePath($resource_id);
        $image_path = "";
        if ($request->hasFile('image')) {
            $image_path = storeImage($request,$request->image,'resource');
        } else {
            $image_path = '';
        }

        if($image_path != ""){
            $arr = array_merge($arr,['image_path' => $image_path]);
        }
        unset($arr['image']);

        $resource= Resource::where('id',$resource_id)->update($arr);
            if($image_path != "" && $currentImagePath != ""){
                if(file_exists($currentImagePath)){
                    unlink($currentImagePath);
                }
            }
        return $resource;
    }

    public function getImagePath($resource_id)
    {
        $image_path = "" ;
        $resource = Resource::find($resource_id);
        if($resource){
            $image_path = $resource->image_path;
        }

        return $image_path;
    }

    public function resourceDelete($request)
    {
        $resource_id = $request->get('resource_id');
        return Resource::where('id',$resource_id)->delete();
    }
}
