<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Directory extends Model
{
    use softDeletes;

    protected $table = 'directory';

    protected $fillable = [
        'id',
        'image_path',
        'title',
        'category_id',
        'description',
        'url',
        'address',
        'phone',
        'latitude',
        'longitude',
        'facebook_url',
        'instagram_url',
        'linkedin_url',
        'twitter_url',
        'video_url',
        'directory_status',
        'order_num',
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'id' => 'integer',
        'image_path' => 'string',
        'category_id' => 'integer',
        'title' => 'string',
        'description' => 'string',
        'url' => 'string',
        'address' => 'string',
        'phone' => 'string',
        'latitude' => 'string',
        'longitude' => 'string',
        'facebook_url' => 'string',
        'instagram_url' => 'string',
        'linkedin_url' => 'string',
        'twitter_url' => 'string',
        'video_url' => 'string',
        'directory_status' => 'string',
        'order_num' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];
}
