<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class EventCategory extends Model
{
    use HasFactory ,SoftDeletes;
    protected $table = 'events_category';

    protected $fillable = [
        'id',
        'image_path',
        'name',
        'category_status',
        'order_num',
        'created_at',
        'updated_at'
    ];

    protected $casts = [
        'id' => 'integer',
        'image_path' => 'string',
        'password' => 'string',
        'name' => 'string',
        'category_status' => 'string',
        'order_num' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];
}
