<?php

namespace App\Models;

use App\Models\Category;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class MapDirectory extends Model
{
    use HasFactory ,softDeletes;

    protected $table = 'map_directory';


    protected $fillable = [
        'id',
        'image_path',
        'category_id',
        'title',
        'description',
        'url',
        'address',
        'phone',
        'latitude',
        'longitude',
        'facebook_url',
        'instagram_url',
        'linkedin_url',
        'twitter_url',
        'video_url',
        'explore_status',
        'order_num',
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'id' => 'integer',
        'image_path' => 'string',
        'category_id' => 'integer',
        'title' => 'string',
        'description' => 'string',
        'url' => 'string',
        'address' => 'string',
        'phone' => 'string',
        'latitude' => 'string',
        'longitude' => 'string',
        'facebook_url' => 'string',
        'instagram_url' => 'string',
        'linkedin_url' => 'string',
        'twitter_url' => 'string',
        'video_url' => 'string',
        'explore_status' => 'string',
        'order_num' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    public function categories(): \Illuminate\Database\Eloquent\Relations\HasOne
    {
        return $this->hasOne(Category::class, 'id', 'category_id');
    }

}
