<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('map_directory', function (Blueprint $table) {
            $table->id();
            $table->integer('category_id');
            $table->string('image_path',199);
            $table->string('title',199);
            $table->text('description')->nullable()->default(null);
            $table->text('url')->nullable()->default(null);
            $table->text('address')->nullable()->default(null);
            $table->string('phone',15);
            $table->string('latitude',25);
            $table->string('longitude',25);
            $table->text('facebook_url')->nullable()->default(null);
            $table->text('instagram_url')->nullable()->default(null);
            $table->text('linkedin_url')->nullable()->default(null);
            $table->text('video_url')->nullable()->default(null);
            $table->enum('explore_status',['active','inactive'])->default('active');
            $table->softDeletes();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('map_directory');
    }
};
